//===============================================================================================
// Defines common payment transition entries and hooks for variable substitutions
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

//-----------------------------------------------------------------------------------------------
// Buy online transition map, "xxxx" indicates a transition variable (for visual readability only)
//-----------------------------------------------------------------------------------------------
var kBuyOnlineTransitions = new Array(

	new zTransitionMap( "payOnline.htm", new Array(
									new zTransitionMapItem( "next", "payBillingInfo.htm" ),
									new zTransitionMapItem( "back", "xxxx" )
								)),
								
	new zTransitionMap( "payBillingInfo.htm", new Array(
									new zTransitionMapItem( "next", null, "actShippingRequired" ),
									new zTransitionMapItem( "back", "payOnline.htm" )
								)),

	new zTransitionMap( "actShippingRequired", new Array(
									new zTransitionMapItem( "yes",	"payShippingInfo.htm" ),
									new zTransitionMapItem( "no",		"payReviewOrder.htm" )
								)),
								
	new zTransitionMap( "payReviewOrder.htm", new Array(
									new zTransitionMapItem( "next", "paySubmittingOrder.htm" ),
									new zTransitionMapItem( "back", "payBillingInfo.htm" )
								)),

	new zTransitionMap( "payShippingInfo.htm", new Array(
									new zTransitionMapItem( "next", "payReviewOrder.htm?shipping" ),
									new zTransitionMapItem( "back", "payBillingInfo.htm" )
								)),
								
	new zTransitionMap( "payReviewOrder.htm?shipping", new Array(
									new zTransitionMapItem( "next", "paySubmittingOrder.htm" ),
									new zTransitionMapItem( "back", "payShippingInfo.htm" )
								)),
								
	new zTransitionMap( "paySubmittingOrder.htm", new Array(
									new zTransitionMapItem( "next", null, "actSubmitOrder" )
								)),

	new zTransitionMap( "actSubmitOrder", new Array(
									new zTransitionMapItem( "ok",							"xxxx", "xxxx" ),
									new zTransitionMapItem( "failed",					"payOnline.htm" ),
									new zTransitionMapItem( "duplicateCheckFailed",	"payDuplicateOrderCheck.htm" ),
									new zTransitionMapItem( "internalServerError",	"payInternalServerError.htm" ),
									new zTransitionMapItem( "writeRegistryError",	"payWriteRegistryError.htm" ),
									new zTransitionMapItem( "priceChanged",			"payReviewOrder.htm" )
								)),

	// Submit order submission exception cases
	new zTransitionMap( "payDuplicateOrderCheck.htm", new Array(
									new zTransitionMapItem( "continue", "paySubmittingOrder.htm" ),
									new zTransitionMapItem( "cancel",	null, "actCancel" )
								)),

	new zTransitionMap( "payInternalServerError.htm", new Array(
									new zTransitionMapItem( "continue", "xxxx" ),
									new zTransitionMapItem( "cancel",	null, "actCancel" )
								)),
	
	new zTransitionMap( "payWriteRegistryError.htm", new Array(
									new zTransitionMapItem( "cancel",	null, "actCancel" )
								))
);
	
//-----------------------------------------------------------------------------------------------
// Buy by phone transition map
//-----------------------------------------------------------------------------------------------
var kBuyByPhoneTransitions = new Array(

	new zTransitionMap( "payByPhone.htm", new Array(
									new zTransitionMapItem( "ok", "xxxx", "xxxx" ),
									new zTransitionMapItem( "back", "xxxx" )
								))
);


//-----------------------------------------------------------------------------------------------
// Specifies a subtitution value...
//		1. Finds the zTransitionMap for the specified pageName.
//		2. Finds the zTransitionMap child zTransitionMapItem matching the specified choiceId.
//		3. Substitutes the matching zTransitionMapItem with the specified destPage and destAct.
//-----------------------------------------------------------------------------------------------
function zTransitionVariable( pageName, choiceId, destPage, destAct )
{
	this.pageName = pageName;
	this.choiceId = choiceId;
	if( destPage ) this.destPage = destPage;
	if( destAct ) this.destAct = destAct;	
}

p = zTransitionVariable.prototype;
p.destPage = null;
p.destAct = null;

p = null;

//-----------------------------------------------------------------------------------------------
// Method to append common transition the concrete transition map
//-----------------------------------------------------------------------------------------------
function substituteTransitionVars( maps, substVars )
	// Substitutes the specified map with the array of specified substitution variables.
{
	if( !maps || !substVars ) return;
	
	var substCnt = substVars.length;		
	for( var i=0; i<substCnt; ++i ) substituteATransitionVar( maps, substVars[i] );
}

//-----------------------------------------------------------------------------------------------
function substituteATransitionVar( maps, substVar )
{
	if( !maps || !substVar ) return;

	try
	{
		var cnt = maps.length;
		var mapEntry = null;
		
		// Find the matching map item
		for( var i=0; i<cnt; ++i )
		{
			if( maps[i].pageName == substVar.pageName )
			{
				mapEntry = maps[i];
				break;
			}
		}

		if( !mapEntry ) throw "subst pageName " +substVar.pageName+ " not found";
		
		// Get the matching child map item
		var item = mapEntry.find( substVar.choiceId );
		if( !item ) throw "subst choiceId " +substVar.choiceId+ "not found";
		
		item.pageName = substVar.destPage;
		item.action = substVar.destAct;
	}
	catch( e ) { alert("substituteATransitionVar: "+e); return; }
}

//-----------------------------------------------------------------------------------------------
function appendBuyOnlineTransitions( sequence, substVars )
	// Add the buy online sequence to the specified map.
	// fromPage specifies the page name prior to this sequence.
	// toPage specifies the page to go to upon completion
{
	if(!sequence) return;

	// Substitute in the from/to pages into the common sequence
	substituteTransitionVars( kBuyOnlineTransitions, substVars );
	
	// Add the items into the main map
	var srcCnt = kBuyOnlineTransitions.length;
	
	for( var i=0; i<srcCnt; ++i ) sequence.maps[sequence.mapCnt++]=kBuyOnlineTransitions[i];
}

//-----------------------------------------------------------------------------------------------
function appendBuyByPhoneTransitions( sequence, substVars )
	// Add the buy online sequence to the specified map.
	// fromPage specifies the page name prior to this sequence.
	// toPage specifies the page to goto upon completion
{
	if(!sequence) return;
	
	// Substitute in the from/to pages into the common sequence
	substituteTransitionVars( kBuyByPhoneTransitions, substVars );
	
	// Add the items into the main map
	var srcCnt = kBuyByPhoneTransitions.length;
	
	for( var i=0; i<srcCnt; ++i ) sequence.maps[sequence.mapCnt++]=kBuyByPhoneTransitions[i];
}

